% ALPHA ENGINE DEFINITION
% Generated 07-Dec-2017 08:00:39

% SUGGESTED CITATION:
% Honda 1.5L Turbo Prototype Engine from 2016 SAE Paper - ALPHA Map Package. Version 2017-12. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2017.


% Constructor
engine = class_REVS_engine();
engine.name =  'Honda 1.5L Turbo Prototype Engine from 2016 SAE Paper'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.496; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10.6; 
engine.stroke_mm =  89.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [  0.00000000,	;  104.71976,	;  149.11051,	;  178.02358,	;  523.59878,	;  575.95865,	;  628.31853,	;  659.73446,	;  722.56631,	 ]; 
engine.full_throttle_torque_Nm = [  0.00000000,	;  125.00000,	;  184.58127,	;  220.00000,	;  220.00000,	;  220.00000,	;  206.90000,	;  177.34286,	; 0.00000000,	 ]; 
engine.naturally_aspirated_speed_radps = [  0.00000000,	;  722.56631,	 ]; 
engine.naturally_aspirated_torque_Nm = [   107.14311,	 107.14311,	 ]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [  0.00000000,	;  109.95574,	;  733.03829,	 ]; 
engine.closed_throttle_torque_Nm = [  -11.931733,	; -15.467733,	; -32.449600,	 ]; 

% Fuel Map
engine.fuel_map_speed_radps = [  0.00000000,	 52.359878,	 78.539816,	 104.71976,	 130.89969,	 157.07963,	 183.25957,	 209.43951,	 235.61945,	 261.79939,	 287.97933,	 314.15927,	 340.33920,	 366.51914,	 418.87902,	 471.23890,	 523.59878,	 575.95865,	 628.31853,	 680.67841,	 733.03829,	 ]; 
engine.fuel_map_torque_Nm = [  -34.072080,	; -13.036040,	;  8.0000000,	;  16.833333,	;  25.666667,	;  34.500000,	;  43.333333,	;  52.166667,	;  61.000000,	;  69.833333,	;  78.666667,	;  87.500000,	;  96.333333,	;  105.16667,	;  114.00000,	;  122.83333,	;  131.66667,	;  140.50000,	;  149.33333,	;  158.16667,	;  167.00000,	;  175.83333,	;  184.66667,	;  193.50000,	;  202.33333,	;  211.16667,	;  220.00000,	;  231.00000,	 ]; 
engine.fuel_map_gps = [
0.016283444, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.0078965971, 0.033875377, 0.064787645, 0.099429306, 0.13650963, 0.17477083, 0.25147395, 0.31304046, 0.34753731, 0.34797318, 0.31497261, 0.25819436, 0.18972616, ;
0.092395102, 0.072592196, 0.065204350, 0.063219707, 0.071894606, 0.092783111, 0.12447500, 0.16431515, 0.20966038, 0.25849509, 0.30958412, 0.36233605, 0.41653300, 0.47206517, 0.58836670, 0.70896164, 0.82650873, 0.92989128,  1.0006424,  1.0225003,  1.0215623, ;
0.13498624, 0.16154322, 0.15559946, 0.14843675, 0.18100395, 0.23326594, 0.29449371, 0.35925422, 0.42513967, 0.49115167, 0.55728774, 0.62413773, 0.69262699, 0.76350081, 0.91786650,  1.0945181,  1.2895069,  1.4928613,  1.6812178,  1.7876405,  1.8779166, ;
0.13471402, 0.17377818, 0.18743556, 0.20683532, 0.24912358, 0.30733100, 0.37415526, 0.44446005, 0.51588524, 0.58767723, 0.65987960, 0.73283652, 0.80733696, 0.88440856,  1.0541304,  1.2537074,  1.4804277,  1.7202607,  1.9460406,  2.1107526,  2.2580101, ;
0.13092185, 0.19005741, 0.22416991, 0.26545976, 0.31852035, 0.38290048, 0.45415395, 0.52928508, 0.60529584, 0.68275353, 0.76132452, 0.84114381, 0.92190021,  1.0052153,  1.1898301,  1.4122647,  1.6709805,  1.9466203,  2.2111338,  2.4379793,  2.6485763, ;
0.12780370, 0.21313408, 0.26366828, 0.31986218, 0.38301648, 0.45394546, 0.52903785, 0.61050108, 0.69111275, 0.77502713, 0.86050906, 0.94885128,  1.0367416,  1.1271230,  1.3254530,  1.5712450,  1.8628778,  2.1753428,  2.4838038,  2.7745047,  3.0540551, ;
0.12849979, 0.24143393, 0.30438506, 0.37085796, 0.44060248, 0.51292357, 0.59335746, 0.68115984, 0.77201734, 0.86265558, 0.95678531,  1.0537340,  1.1524777,  1.2524524,  1.4619680,  1.7328649,  2.0583992,  2.4097327,  2.7682294,  3.1258502,  3.4799461, ;
0.13432586, 0.27295103, 0.34567370, 0.41977002, 0.49388631, 0.56805083, 0.65465297, 0.74902020, 0.85321623, 0.95321847,  1.0543827,  1.1587478,  1.2713215,  1.3822266,  1.6024678,  1.9008693,  2.2598128,  2.6523718,  3.0672613,  3.4972410,  3.9324761, ;
0.14509424, 0.30651512, 0.38781641, 0.46880132, 0.54959286, 0.63170838, 0.72525949, 0.83093637, 0.94195894,  1.0522272,  1.1596191,  1.2736771,  1.3922663,  1.5114419,  1.7570576,  2.0804510,  2.4687215,  2.9051510,  3.3833989,  3.8934997,  4.4181015, ;
0.15982659, 0.34189471, 0.43235965, 0.52240156, 0.61233225, 0.70246744, 0.80547766, 0.92056811,  1.0394159,  1.1590269,  1.2795637,  1.4031204,  1.5302959,  1.6594889,  1.9284850,  2.2720029,  2.6857082,  3.1696975,  3.7193105,  4.3191503,  4.9429362, ;
0.17740760, 0.37959939, 0.48009533, 0.58071547, 0.68174147, 0.78265351, 0.89773328,  1.0230707,  1.1523797,  1.2811702,  1.4116738,  1.5454062,  1.6828567,  1.8223521,  2.1177280,  2.4741632,  2.9106791,  3.4478746,  4.0781465,  4.7785306,  5.5121486, ;
0.19685388, 0.42018424, 0.53128791, 0.64248156, 0.75417026, 0.86914533, 0.99706947,  1.1342671,  1.2761462,  1.4121957,  1.5516558,  1.6965358,  1.8454186,  1.9975007,  2.3198775,  2.6852815,  3.1438507,  3.7422461,  4.4637667,  5.2758266,  6.1293454, ;
0.21732120, 0.46365743, 0.58631574, 0.70896854, 0.83331610, 0.96198702,  1.1010084,  1.2481066,  1.3989975,  1.5463892,  1.6962869,  1.8542120,  2.0154380,  2.1798892,  2.5255887,  2.9036044,  3.3872784,  4.0563772,  4.8809383,  5.8149864,  6.7959660, ;
0.23809547, 0.50954267, 0.64548885, 0.78177378, 0.91971327,  1.0596059,  1.2080281,  1.3647144,  1.5252309,  1.6855810,  1.8459195,  2.0154970,  2.1886482,  2.3660940,  2.7412459,  3.1276051,  3.6471496,  4.3948693,  5.3355042,  6.3994612,  7.5107465, ;
0.25858084, 0.55701482, 0.70757384, 0.85878593,  1.0096501,  1.1596749,  1.3186946,  1.4873539,  1.6597256,  1.8330421,  2.0063484,  2.1793586,  2.3603440,  2.5530613,  2.9686108,  3.3553379,  3.9211205,  4.7633678,  5.8343883,  7.0316831,  8.2693623, ;
0.27812983, 0.60505013, 0.77021472, 0.93605776,  1.1002647,  1.2624965,  1.4361995,  1.6188319,  1.8030298,  1.9873680,  2.1724665,  2.3582024,  2.5434425,  2.7392249,  3.1998731,  3.5866172,  4.2042091,  5.1697569,  6.3849322,  7.7122152,  9.0644027, ;
0.29578380, 0.65287694, 0.83215895,  1.0115739,  1.1903709,  1.3696526,  1.5608968,  1.7586591,  1.9538000,  2.1473677,  2.3420156,  2.5386440,  2.7377490,  2.9439019,  3.4084191,  3.8284610,  4.5008953,  5.6254951,  6.9933942,  8.4386529,  9.8858235, ;
0.31018892, 0.70020133, 0.89448632,  1.0884873,  1.2832974,  1.4819962,  1.6893436,  1.9007042,  2.1085586,  2.3126251,  2.5176241,  2.7257761,  2.9386337,  3.1578537,  3.6229203,  4.1001236,  4.8297076,  6.1445963,  7.6627515,  9.2045295,  10.721956, ;
0.31982084, 0.74710215, 0.95885803,  1.1700050,  1.3819707,  1.5986945,  1.8224635,  2.0491242,  2.2693522,  2.4845536,  2.7023420,  2.9245774,  3.1518539,  3.3840883,  3.8709365,  4.4271910,  5.2358224,  6.7382756,  8.3900801,  9.9985825,  11.561008, ;
0.32332243, 0.79345287,  1.0258330,  1.2572610,  1.4891626,  1.7222049,  1.9632722,  2.2083897,  2.4413115,  2.6676131,  2.8999164,  3.1399183,  3.3850309,  3.6337246,  4.1620801,  4.8292054,  5.8110390,  7.4045493,  9.1638699,  10.804833,  12.392774, ;
0.31977358, 0.83845126,  1.0947193,  1.3487689,  1.6004415,  1.8511479,  2.1100700,  2.3708225,  2.6210328,  2.8649638,  3.1154510,  3.3773762,  3.6456830,  3.9159662,  4.4959637,  5.3088538,  6.4726814,  8.1184919,  9.9602288,  11.604118,  13.210054, ;
0.30887673, 0.88042074,  1.1635894,  1.4438331,  1.7183036,  1.9868843,  2.2650186,  2.5459626,  2.8114322,  3.0746020,  3.3497260,  3.6419949,  3.9409792,  4.2426014,  4.8917426,  5.8609307,  7.1670233,  8.8446331,  10.732473,  12.378074,  14.009104, ;
0.29104633, 0.91786334,  1.2297907,  1.5401209,  1.8468516,  2.1441271,  2.4343151,  2.7325995,  3.0227640,  3.3126180,  3.6161671,  3.9370567,  4.2859017,  4.6387334,  5.3943382,  6.4793829,  7.8675376,  9.5545274,  11.415009,  13.116293,  14.788658, ;
0.26730044, 0.95052204,  1.2917977,  1.6324490,  1.9710612,  2.3045107,  2.6275936,  2.9454406,  3.2702516,  3.6061489,  3.9469855,  4.3096722,  4.7206310,  5.1394217,  6.0565310,  7.1569995,  8.5604720,  10.238717,  12.062963,  13.822261,  15.548398, ;
0.23900054, 0.97877593,  1.3491951,  1.7196543,  2.0893766,  2.4568689,  2.8196393,  3.1742076,  3.5406305,  3.9236042,  4.3207254,  4.7409948,  5.1982046,  5.7041453,  6.7972206,  7.8620111,  9.2399693,  10.901266,  12.701268,  14.506075,  16.289891, ;
0.20758581,  1.0034225,  1.4025468,  1.8023574,  2.2027567,  2.6033757,  3.0039468,  3.4065154,  3.8213841,  4.2542805,  4.7086628,  5.1897381,  5.7043839,  6.2556034,  7.4385914,  8.5585587,  9.9067283,  11.551596,  13.339031,  15.177743,  17.016869, ;
0.17437222,  1.0255872,  1.4530235,  1.8819256,  2.3132031,  2.7482053,  3.1892987,  3.6406027,  4.1073291,  4.5946360,  5.1067288,  5.6459877,  6.2125457,  6.8021654,  8.0418280,  9.2389883,  10.568934,  12.198430,  13.978308,  15.844218,  17.734431, ;
0.13181515,  1.0512520,  1.5136114,  1.9786810,  2.4491103,  2.9286914,  3.4220152,  3.9336083,  4.4670648,  5.0252428,  5.6092093,  6.2167118,  6.8421756,  7.4787681,  8.7782941,  10.071802,  11.422054,  13.005693,  14.775855,  16.671775,  18.621181, ]; 

% Fuel Properties
engine.fuel = class_REVS_fuel;
engine.fuel.density_kgpL_15C =  0.743; 
engine.fuel.energy_density_MJpkg =  43.1; 
engine.fuel.research_octane_number =  91; 

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [  0.00000000,	 10.000000,	 ]; 
engine.idle_speed_radps.table = [   65.973446,	;  65.973446,	 ]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
